# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dataprotection.aio import DataProtectionMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataProtectionMgmtBackupPoliciesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataProtectionMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_backup_policies_get(self, resource_group):
        response = await self.client.backup_policies.get(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_policy_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_backup_policies_create_or_update(self, resource_group):
        response = await self.client.backup_policies.create_or_update(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_policy_name="str",
            parameters={
                "id": "str",
                "name": "str",
                "properties": "base_backup_policy",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_backup_policies_delete(self, resource_group):
        response = await self.client.backup_policies.delete(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_policy_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_backup_policies_list(self, resource_group):
        response = self.client.backup_policies.list(
            resource_group_name=resource_group.name,
            vault_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
