﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.Diagnostics.CodeAnalysis;
// We don't own these names; the OS does
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.AbntC2")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumPad0")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumPad2")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumPad5")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumPad7")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumPad9")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumPad1")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.DbeSbcsChar")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumPad3")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumPad8")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.JunjaMode")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.OemEnlw")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.DbeDbcsChar")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumPad4")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumLock")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.NumPad6")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.EraseEof")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Input.Key.AbntC1")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Automation.TransformPattern.Move(System.Double,System.Double):System.Void", MessageId = "0#x")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Automation.TransformPattern.Move(System.Double,System.Double):System.Void", MessageId = "1#y")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "MS.Internal.Automation.Misc.TryMsgWaitForMultipleObjects(Microsoft.Win32.SafeHandles.SafeWaitHandle,System.Boolean,System.Int32,System.Int32,System.Int32&):System.Int32", MessageId = "System.Runtime.InteropServices.SafeHandle.DangerousGetHandle")]
// The type that is passed is correct
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Windows.Automation.Provider.AutomationInteropProvider.RaiseAutomationEvent(System.Windows.Automation.AutomationEvent,System.Windows.Automation.Provider.IRawElementProviderSimple,System.Windows.Automation.AutomationEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Windows.Automation.Automation.PropertyName(System.Windows.Automation.AutomationProperty):System.String")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Windows.Automation.Automation.PatternName(System.Windows.Automation.AutomationPattern):System.String")]
[module: SuppressMessage("Microsoft.Naming", "CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope="type", Target="System.Windows.Automation.AutomationFocusChangedEventArgs")]
// The rule doesn't apply to non-public namespaces
[module: SuppressMessage("Microsoft.MSInternal", "CA904:DeclareTypesInMicrosoftOrSystemNamespace", Scope = "namespace", Target = "MS.Internal")]
[module: SuppressMessage("Microsoft.MSInternal", "CA904:DeclareTypesInMicrosoftOrSystemNamespace", Scope = "namespace", Target = "MS.Win32")]
// Reviewed by WinFX team and this case is OK
[module: SuppressMessage("Microsoft.Design", "CA1008:EnumsShouldHaveZeroValue", Scope = "type", Target = "System.Windows.Automation.Text.FlowDirections")]
// Reviewed by atgarch and these enums are OK
[module: SuppressMessage("Microsoft.Naming", "CA1714:FlagsEnumsShouldHavePluralNames", Scope = "type", Target = "System.Windows.Automation.TreeScope")]
[module: SuppressMessage("Microsoft.Naming", "CA1714:FlagsEnumsShouldHavePluralNames", Scope = "type", Target = "System.Windows.Automation.ClientSideProviderMatchIndicator")]
[module: SuppressMessage("Microsoft.Naming", "CA1714:FlagsEnumsShouldHavePluralNames", Scope = "type", Target = "System.Windows.Automation.SupportedTextSelection")]
// Reviewed and these are spelled correctly
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Automation.AutomationElement.IsOffscreenProperty")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Automation.AutomationElement+AutomationElementInformation.IsOffscreen")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Automation.TextPattern.OverlineStyleAttribute")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Automation.TextPattern.OverlineColorAttribute")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Automation.Provider.AutomationInteropProvider.ReturnRawElementProvider(System.IntPtr,System.IntPtr,System.IntPtr,System.Windows.Automation.Provider.IRawElementProviderSimple):System.IntPtr")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Automation.Provider.IWindowProvider.Maximizable")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Automation.Provider.IWindowProvider.Minimizable")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Rect.Offset(System.Windows.Rect,System.Double,System.Double):System.Windows.Rect")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Rect.Offset(System.Double,System.Double):System.Void")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Point.Offset(System.Double,System.Double):System.Void")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Windows.Automation.Text.CapStyle.Unicase")]

// Reviewed and these are correctly cased
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "ExceptionStringTable.resources", MessageId = "classname")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "ExceptionStringTable.resources", MessageId = "imagename")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "ExceptionStringTable.resources", MessageId = "nonenabled")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "ExceptionStringTable.resources", MessageId = "clientside")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "StringTable.resources", MessageId = "dataitem")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "StringTable.resources", MessageId = "datagrid")]

// Reviewed and these are correctly suffixed
[module: SuppressMessage("Microsoft.Naming", "CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope = "type", Target = "System.Windows.Automation.AutomationTextAttribute")]
[module: SuppressMessage("Microsoft.Naming", "CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope = "type", Target = "System.Windows.Automation.PropertyConditionFlags")]
// These could just be moved outside of the using class but having the class nested helps code readability
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.MultipleViewPattern+MultipleViewPatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.GridPattern+GridPatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.TogglePattern+TogglePatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.SelectionPattern+SelectionPatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.RangeValuePattern+RangeValuePatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.TablePattern+TablePatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.ValuePattern+ValuePatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.SelectionItemPattern+SelectionItemPatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.AutomationElement+AutomationElementInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.GridItemPattern+GridItemPatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.ExpandCollapsePattern+ExpandCollapsePatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.WindowPattern+WindowPatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.DockPattern+DockPatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.TableItemPattern+TableItemPatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.ScrollPattern+ScrollPatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "System.Windows.Automation.TransformPattern+TransformPatternInformation")]
// These classes don't typically get compared
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.MultipleViewPattern+MultipleViewPatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.GridPattern+GridPatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.TogglePattern+TogglePatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.SelectionPattern+SelectionPatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.RangeValuePattern+RangeValuePatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.TablePattern+TablePatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.ValuePattern+ValuePatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.SelectionItemPattern+SelectionItemPatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.AutomationElement+AutomationElementInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.GridItemPattern+GridItemPatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.ExpandCollapsePattern+ExpandCollapsePatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.WindowPattern+WindowPatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.DockPattern+DockPatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.TableItemPattern+TableItemPatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.ScrollPattern+ScrollPatternInformation")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.TransformPattern+TransformPatternInformation")]
[module: SuppressMessage("Microsoft.Design", "CA1036:OverrideMethodsOnComparableTypes", Scope = "type", Target = "System.Windows.Automation.AutomationIdentifier")]
// Not exposed for V1; Consider this rule for V2
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope = "type", Target = "System.Windows.Automation.ClientSideProviderDescription")]
// Not required for non-public code
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Windows.Automation")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Windows.Automation.Provider")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Windows.Input")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Windows.Automation.Text")]
[module: SuppressMessage("Microsoft.Naming", "CA1724:TypeNamesShouldNotMatchNamespaces", Scope = "type", Target = "System.Windows.Automation.Automation")]
// Not appropriate; these are lower level events
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Windows.Automation.Provider.AutomationInteropProvider.RaiseAutomationPropertyChangedEvent(System.Windows.Automation.Provider.IRawElementProviderSimple,System.Windows.Automation.AutomationPropertyChangedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Windows.Automation.Provider.AutomationInteropProvider.RaiseAutomationEvent(System.Windows.Automation.AutomationEvent,System.Windows.Automation.Provider.IRawElementProviderSimple,System.Windows.Automation.AutomationEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Windows.Automation.Provider.AutomationInteropProvider.RaiseStructureChangedEvent(System.Windows.Automation.Provider.IRawElementProviderSimple,System.Windows.Automation.StructureChangedEventArgs):System.Void")]
// SafeHandle isn't appropriate here; these are wrapped in classes that release resources though
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi+UiaAndOrCondition._conditions")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi+UiaCacheRequest._pPatterns")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi+UiaCacheRequest._pProperties")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi+UiaFindParams.pFindCondition")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi+UiaMiniCacheRequest._pCondition")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi+UiaMiniCacheRequest._pPatterns")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi+UiaMiniCacheRequest._pProperties")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi+UiaNotCondition._condition")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi+UiaStructureChangedEventArgs._pRuntimeId")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi+UiaWindowClosedEventArgs._pRuntimeId")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.FocusTracker._hwndLastBeforeMenu")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.BoundingRectTracker._lastHwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.WinEventWrap+WinEvent._hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.WindowInteractionStateTracker._lastHwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.Automation.Accessible._hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Win32.UnsafeNativeMethods.HTCLIENT")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Win32.UnsafeNativeMethods.HTTRANSPARENT")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Win32.UnsafeNativeMethods.INVALID_HANDLE_VALUE")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Win32.UnsafeNativeMethods+MENUBARINFO.hMenu")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Win32.UnsafeNativeMethods+MSG.lParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Win32.UnsafeNativeMethods+MSG.wParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Win32.NativeMethods+HWND.h")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Win32.UnsafeNativeMethods+KEYBDINPUT.dwExtraInfo")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Win32.UnsafeNativeMethods+MOUSEINPUT.dwExtraInfo")]

// The method uses a large switch as a covertion table.  Safe to exclude.
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="System.Windows.Input.KeyInterop.KeyFromVirtualKey(System.Int32):System.Windows.Input.Key")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="System.Windows.Input.KeyInterop.VirtualKeyFromKey(System.Windows.Input.Key):System.Int32")]

// SafeHandle is not marshalled when in Structs.  See comments in code.
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi.UiaNodeFromFocus(MS.Internal.Automation.UiaCoreApi+UiaCacheRequest):MS.Internal.Automation.UiaCoreApi+UiaCacheResponse", MessageId = "System.Runtime.InteropServices.SafeHandle.DangerousGetHandle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi.UiaNodeFromPoint(System.Double,System.Double,MS.Internal.Automation.UiaCoreApi+UiaCacheRequest):MS.Internal.Automation.UiaCoreApi+UiaCacheResponse", MessageId = "System.Runtime.InteropServices.SafeHandle.DangerousGetHandle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi.UiaNavigate(MS.Internal.Automation.SafeNodeHandle,System.Windows.Automation.Provider.NavigateDirection,System.Windows.Automation.Condition,MS.Internal.Automation.UiaCoreApi+UiaCacheRequest):MS.Internal.Automation.UiaCoreApi+UiaCacheResponse", MessageId = "System.Runtime.InteropServices.SafeHandle.DangerousGetHandle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi.UiaAddEvent(MS.Internal.Automation.SafeNodeHandle,System.Int32,MS.Internal.Automation.UiaCoreApi+UiaEventCallback,System.Windows.Automation.TreeScope,System.Int32[],MS.Internal.Automation.UiaCoreApi+UiaCacheRequest):MS.Internal.Automation.SafeEventHandle", MessageId = "System.Runtime.InteropServices.SafeHandle.DangerousGetHandle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi.UiaGetUpdatedCache(MS.Internal.Automation.SafeNodeHandle,MS.Internal.Automation.UiaCoreApi+UiaCacheRequest,MS.Internal.Automation.UiaCoreApi+NormalizeState,System.Windows.Automation.Condition):MS.Internal.Automation.UiaCoreApi+UiaCacheResponse", MessageId = "System.Runtime.InteropServices.SafeHandle.DangerousGetHandle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "System.Windows.Automation.NotCondition..ctor(System.Windows.Automation.Condition)", MessageId = "System.Runtime.InteropServices.SafeHandle.DangerousGetHandle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "System.Windows.Automation.AndCondition..ctor(System.Windows.Automation.Condition[])", MessageId = "System.Runtime.InteropServices.SafeHandle.DangerousGetHandle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "System.Windows.Automation.OrCondition..ctor(System.Windows.Automation.Condition[])", MessageId = "System.Runtime.InteropServices.SafeHandle.DangerousGetHandle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2004:RemoveCallsToGCKeepAlive", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi.UiaNodeFromFocus(MS.Internal.Automation.UiaCoreApi+UiaCacheRequest):MS.Internal.Automation.UiaCoreApi+UiaCacheResponse")]
[module: SuppressMessage("Microsoft.Reliability", "CA2004:RemoveCallsToGCKeepAlive", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi.UiaNodeFromPoint(System.Double,System.Double,MS.Internal.Automation.UiaCoreApi+UiaCacheRequest):MS.Internal.Automation.UiaCoreApi+UiaCacheResponse")]
[module: SuppressMessage("Microsoft.Reliability", "CA2004:RemoveCallsToGCKeepAlive", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi.UiaNavigate(MS.Internal.Automation.SafeNodeHandle,System.Windows.Automation.Provider.NavigateDirection,System.Windows.Automation.Condition,MS.Internal.Automation.UiaCoreApi+UiaCacheRequest):MS.Internal.Automation.UiaCoreApi+UiaCacheResponse")]
[module: SuppressMessage("Microsoft.Reliability", "CA2004:RemoveCallsToGCKeepAlive", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi.UiaAddEvent(MS.Internal.Automation.SafeNodeHandle,System.Int32,MS.Internal.Automation.UiaCoreApi+UiaEventCallback,System.Windows.Automation.TreeScope,System.Int32[],MS.Internal.Automation.UiaCoreApi+UiaCacheRequest):MS.Internal.Automation.SafeEventHandle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2004:RemoveCallsToGCKeepAlive", Scope = "member", Target = "MS.Internal.Automation.UiaCoreApi.UiaGetUpdatedCache(MS.Internal.Automation.SafeNodeHandle,MS.Internal.Automation.UiaCoreApi+UiaCacheRequest,MS.Internal.Automation.UiaCoreApi+NormalizeState,System.Windows.Automation.Condition):MS.Internal.Automation.UiaCoreApi+UiaCacheResponse")]
