#!/bin/bash

set -e

version=${1:?Usage: $0 <version>}
branch=$(git branch --show-current)
TMPDIR=$(mktemp -d)

echo "Installing to $TMPDIR for Horizon $version"

mkdir -p $TMPDIR/lib

grep -i xstatic requirements.txt > $TMPDIR/requirements.txt

pip3 install -t $TMPDIR/lib -r $TMPDIR/requirements.txt -c "https://opendev.org/openstack/requirements/raw/branch/$branch/upper-constraints.txt"

(
    cd $TMPDIR/lib
    ls -lRt
    rm -Rf *.egg-info *.dist-info
    rm -Rf *.pth
    find . -name "*.pyc" -delete
    touch xstatic/__init__.py xstatic/pkg/__init__.py
    tar -czf horizon_${version}.orig-xstatic.tar.gz *
)

mv  $TMPDIR/lib/horizon_${version}.orig-xstatic.tar.gz ../
rm -rf $TMPDIR

echo ""
echo "xstatic tarball created: ../horizon_${version}.orig-xstatic.tar.gz"
echo ""
echo "To import into gbp:"
echo "  gbp import-orig --component=xstatic --no-interactive --no-merge \\"
echo "      --upstream-version=${version} \\"
echo "      ../horizon_${version}.orig-xstatic.tar.gz"
